﻿#using Tessa.Roles

if (this.ProcessHash.TryGetValue("AdditionalRoles", out var additionalRolesObj)
	&& additionalRolesObj is IList additionalRoles)
{
	foreach(Dictionary<string, object> role in additionalRoles)
	{
		task.AddPerformer(role.TryGet<Guid>("ID"), role.TryGet<string>("Name"), false);
	}
}

if (!string.IsNullOrEmpty((string)Signal.Comment))
{
	task.Result = string.Format(
		LocalizeAndEscapeFormat("$WfResolution_Result_ParentComment"),
		(string) this.Signal.Comment);
}

if (!string.IsNullOrEmpty((string)Signal.KindCaption))
{
	task.Card.DynamicEntries.TaskCommonInfo.KindCaption = (string)Signal.KindCaption;
}

var parentTask = await this.Context.GetTaskAsync(task.ParentRowID.Value);
if (parentTask.State != CardRowState.Deleted)
{
	var mainCard = await this.GetCardObjectAsync();
	parentTask = mainCard.Tasks.FirstOrDefault(x => x.RowID == parentTask.RowID);

	if(parentTask is null)
	{
		this.ValidationResult.AddError(this, $"Parent task (RowID = \"{parentTask.RowID:B}\") not found.");
		return;
	}

	var storeDateTime = DateTime.UtcNow;
	var newRow = parentTask.Card.Sections["WfResolutionChildren"].Rows.Add();
	newRow.RowID = task.RowID;
	var performer = task.TaskAssignedRoles.FirstOrDefault(x => x.Master);
	newRow["PerformerID"] = performer.RoleID;
	newRow["PerformerName"] = performer.RoleName;
	newRow["Comment"] = (string) this.Signal.Comment;
	newRow["Created"] = task.Card.Created ?? storeDateTime;
	newRow["Planned"] = task.Planned ?? storeDateTime;
	newRow.State = CardRowState.Inserted;

	if (parentTask.State != CardRowState.Inserted)
	{
		parentTask.State = CardRowState.Modified;
	}
}
